% This function is used to preprocess the rois sed in the local
% registration. imgin is the input image, minval e maxval are values used
% to avoid outliers (standard values: 0.7, 0.95)

function imgout = preprocess_small_hippo(imgin, minval, maxval)

    imgout = 1-imgin;
    imrow = sort(imgout(:));
    bottom = imrow(ceil((minval)*length(imrow)));
    top = imrow(ceil((maxval)*length(imrow)));
    imgout = (imgout-bottom)/(top-bottom);
    imgout(imgout<0) = 0;
    imgout(imgout>1) = 1;

end